/*=============================================================================

  Library: CTK

  Copyright (c) 4DVisualizationLab

  Licensed under the Apache License, Version 2.0 (the "License");
  you may not use this file except in compliance with the License.
  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

  Unless required by applicable law or agreed to in writing, software
  distributed under the License is distributed on an "AS IS" BASIS,
  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  See the License for the specific language governing permissions and
  limitations under the License.

=============================================================================*/


#ifndef trackerNavigationPlugin_H
#define trackerNavigationPlugin_H


#include "ui_toolFrameTrackerNavigationGUI.h"
#include "ui_mainFrameTrackerNavigationViewGUI.h"
#include "dicomDataInterface.h"
#include "trackerNavigationInterface.h"


#include <ctkPluginActivator.h>

/** QT header files */
#include <QString>
#include <QFileInfo>
#include <QtGui>
#include <QObject>
#include <QApplication>
#include <QMainWindow>
#include <QMessageBox>
#include <QtCore/QTimer>
#include <QDesktopServices>
#include <QDialog>
#include <QFileDialog>
//#include "QVTKWidget.h"
#include <QPushButton>
#include <QAbstractButton>
#include <QButtonGroup>
#include <QWidget>


/** CTK headers */
#include <ctkServiceTracker.h>
#include <service/event/ctkEventHandler.h>
#include <service/event/ctkEvent.h>


/** ITK headers */
#include "itkStdStreamLogOutput.h"
#include "igstkTransform.h"

/** VTK header files */
#include "vtkCallbackCommand.h"



/** IGSTK header files */
#include "igstkConfigure.h"

#include "igstkStateMachine.h"
#include "igstkMacros.h"
#include "igstkObject.h"
#include "igstkEvents.h"

#include "igstkCTImageReader.h"
#include "igstkCTImageSpatialObjectRepresentation.h"

#include "igstkMeshReader.h"
#include "igstkMeshObjectRepresentation.h"
#include "igstkMeshResliceObjectRepresentation.h"

#include "igstkReslicerPlaneSpatialObject.h"
#include "igstkImageResliceObjectRepresentation.h"

#include "igstkTracker.h"
#include "igstkTrackerTool.h"

#include "igstkLandmark3DRegistration.h"

#include "igstkEllipsoidObject.h"
#include "igstkEllipsoidObjectRepresentation.h"

#include "igstkCylinderObject.h"
#include "igstkCylinderObjectRepresentation.h"

#include "igstkAxesObject.h"

#include "igstkToolProjectionSpatialObject.h"
#include "igstkToolProjectionObjectRepresentation.h"

#include "igstkCrossHairSpatialObject.h"
#include "igstkCrossHairObjectRepresentation.h"

#include "igstkAnnotation2D.h"

#include "itkStdStreamLogOutput.h"

#include "igstkCoordinateSystemTransformToResult.h"

#include "igstkView.h"
#include "igstkView2D.h"
#include "igstkView3D.h"

#include "igstkFiducialsPlanIO.h"
#include "igstkPathPlanIO.h"

#include "igstkTransformObserver.h"

#include "igstkCoordinateSystemTransformToResult.h"




#if !defined(_WIN32) && !defined(_WIN64) // Linux - Unix
    #  include <sys/time.h>
    typedef timeval sys_time_t;
    inline void system_time(sys_time_t* t) {
        gettimeofday(t, NULL);
    }
    inline long long time_to_msec(const sys_time_t& t) {
        return t.tv_sec * 1000LL + t.tv_usec / 1000;
    }
    #else // Windows and MinGW
    #  include <sys/timeb.h>
    typedef _timeb sys_time_t;
    inline void system_time(sys_time_t* t) { _ftime(t); }
    inline long long time_to_msec(const sys_time_t& t) {
        return t.time * 1000LL + t.millitm;
    }
#endif

class trackerNavigationPlugin :  public QObject,  public ctkEventHandler, public ctkPluginActivator
{
	Q_OBJECT
	Q_INTERFACES(ctkEventHandler ctkPluginActivator)



/*
//Class that observes the events generated by the tracker controller.
class TrackerControllerObserver : public itk::Command
{
	public:
	typedef TrackerControllerObserver								Self;
	typedef ::itk::Command                       					Superclass;
	typedef ::itk::SmartPointer<Self>            					Pointer;
	typedef ::itk::SmartPointer<const Self>      					ConstPointer;

	igstkNewMacro(Self)
	igstkTypeMacro(TrackerControllerObserver, itk::Command)

	void SetParent(trackerNavigationPlugin *p);

	//Invoke this method when an initialization event occurs.
	void Execute(itk::Object *caller, const itk::EventObject & event);
	void Execute(const itk::Object *caller, const itk::EventObject & event);


	//Clear the current error.
	void ClearError()
	{
	  this->m_ErrorOccured = false;
	  this->m_ErrorMessage.clear();
	}

	//If an error occurs in one of the observed IGSTK components this method will return true.
	bool Error()
	{
	  return this->m_ErrorOccured;
	}

	void GetErrorMessage(std::string &errorMessage)
	{
	  errorMessage = this->m_ErrorMessage;
	}



protected:

	TrackerControllerObserver() : m_Parent(NULL), m_ErrorOccured(false) {}
	virtual ~TrackerControllerObserver(){}


private:

	trackerNavigationPlugin *m_Parent;
	bool m_ErrorOccured;
	std::string m_ErrorMessage;

	//purposely not implemented
	TrackerControllerObserver(const Self&);
	void operator=(const Self&);

};

*/
public:


	/** Typedefs */
	 igstkStandardClassBasicTraitsMacro( trackerNavigationPlugin, QObject );

	igstkLoggerMacro();

	/** Declarations needed for the State Machine */
	// igstkStateMachineMacro();


	typedef igstk::View										ViewType;
	typedef igstk::View2D       							View2DType;
	typedef igstk::View3D       							View3DType;


	/** typedef for image reader */
	typedef igstk::CTImageReader                        	ImageReaderType;

	/** typedef for mesh readers */
	typedef igstk::MeshReader                           	MeshReaderType;

	/** typedef for image spatial objects */
	typedef ImageReaderType::ImageSpatialObjectType     	ImageSpatialObjectType;

	/** typedef for mesh spatial objects */
	typedef MeshReaderType::MeshObjectType              	MeshType;

	/** typedef for a cylinder spatial object and representation
	* used to represent the tracked tool */
	typedef igstk::CylinderObject                      		CylinderType;
	typedef igstk::CylinderObjectRepresentation        		CylinderRepresentationType;

	/** typedef for an image voxel index and world coordinates */
	typedef ImageSpatialObjectType::IndexType           	IndexType;
	typedef ImageSpatialObjectType::PointType           	PointType;

	/** Cross hair spatial object and representation */
	typedef igstk::CrossHairSpatialObject            		CrossHairType;
	typedef igstk::CrossHairObjectRepresentation     		CrossHairRepresentationType;

	/** tool projection spatial object and representation */
	typedef igstk::ToolProjectionSpatialObject             	ToolProjectionType;
	typedef igstk::ToolProjectionObjectRepresentation	   	ToolProjectionRepresentationType;

	/** reslicer plane spatial object */
	typedef igstk::ReslicerPlaneSpatialObject              	ReslicerPlaneType;

	/** tool representation */
	typedef igstk::MeshObjectRepresentation                	MeshRepresentationType;

	/** mesh reslice representation */
	typedef igstk::MeshResliceObjectRepresentation			MeshResliceRepresentationType;

	/** image reslice representation */
	typedef igstk::ImageResliceObjectRepresentation< ImageSpatialObjectType > ImageRepresentationType;


	/** typedef for landmark registration types */
	typedef igstk::Landmark3DRegistration                 	RegistrationType;

	typedef RegistrationType::LandmarkPointContainerType	LandmarkPointContainerType;

	typedef std::map< unsigned int, bool >     				AcceptedLandmarkPointContainerType;


	typedef itk::MemberCommand<trackerNavigationPlugin>     ProgressCommandType;

	typedef igstk::Annotation2D 							Annotation2DImageType;



	/** Public request methods from the GUI */
	/*
	virtual void RequestLoadImage();
	virtual void RequestCancelImageLoad();
	virtual void RequestAcceptImageLoad();
	virtual void RequestLoadMesh();
	virtual void RequestLoadToolSpatialObject();
	virtual void RequestToggleSetImageFiducials();
	virtual void RequestStartSetTrackerFiducials();
	virtual void RequestEndSetTrackerFiducials();
	virtual void RequestAcceptTrackerFiducial();
	virtual void RequestPrepareToQuit();
	*/
	/** Public request methods from the GUI to help operation workflow */

	/**
	* Open the relevant tracker settings dialog (Polaris/Aurora/Micron/Ascension)
	* and get the users input.
	*/
	/*
	virtual void RequestConfigureTracker();
	virtual void RequestInitializeTracker();
	virtual void RequestTrackerRegistration();
	virtual void RequestStartTracking();
	virtual void RequestStopTracking();
	virtual void RequestAcceptRegistration();
	virtual void RequestRejectRegistration();
	virtual void RequestChangeSelectedViewMode();
	virtual void RequestDisconnectTracker();
	 */




	igstkObserverMacro( CoordinateSystemTransform,
		  igstk::CoordinateSystemTransformToEvent,
		  igstk::CoordinateSystemTransformToResult )

	igstkObserverMacro( TransformationDescription,
		  igstk::StringEvent,
		  std::string )



	igstkObserverMacro( DICOMImageReaderInvalidDirectoryNameError,
		  igstk::DICOMImageDirectoryIsNotDirectoryErrorEvent,
		  std::string )

	igstkObserverMacro( DICOMImageReaderNonExistingDirectoryError,
		  igstk::DICOMImageDirectoryDoesNotExistErrorEvent,
		  igstk::EventHelperType::StringType )

	igstkObserverMacro( DICOMImageReaderEmptyDirectoryError,
		  igstk::DICOMImageDirectoryEmptyErrorEvent,
		  igstk::EventHelperType::StringType )

	igstkObserverMacro( DICOMImageDirectoryNameDoesNotHaveEnoughFilesError,
		 igstk::DICOMImageDirectoryDoesNotHaveEnoughFilesErrorEvent,
		 igstk::EventHelperType::StringType )

	igstkObserverMacro( DICOMImageDirectoryDoesNotContainValidDICOMSeriesError,
		  igstk::DICOMImageSeriesFileNamesGeneratingErrorEvent,
		  igstk::EventHelperType::StringType )

	igstkObserverMacro( DICOMImageInvalidError,
		  igstk::DICOMImageReadingErrorEvent,
		  igstk::EventHelperType::StringType )

	/** Define observers for event communication */
	igstkObserverObjectMacro( CTImage, igstk::CTImageReader::ImageModifiedEvent,
					   igstk::CTImageSpatialObject );

	igstkObserverObjectMacro( MeshObject, igstk::MeshReader::MeshModifiedEvent,
							igstk::MeshObject );

	igstkObserverMacro( Registration, igstk::CoordinateSystemTransformToEvent,
						igstk::CoordinateSystemTransformToResult );

	igstkObserverMacro( RegistrationError, igstk::DoubleTypeEvent, double );

	igstkObserverMacro( ImageExtent, igstk::ImageExtentEvent,
		  igstk::EventHelperType::ImageExtentType );

	igstkObserverMacro( VTKImage, igstk::VTKImageModifiedEvent,
		  igstk::EventHelperType::VTKImagePointerType);

	igstkEventMacro( InvalidRequestErrorEvent, igstk::IGSTKErrorEvent );




	trackerNavigationPlugin();
	~trackerNavigationPlugin();

	void start(ctkPluginContext* context);
	void stop(ctkPluginContext* context);

	static trackerNavigationPlugin* getInstance();

	ctkPluginContext* getPluginContext() const;

	void handleEvent(const ctkEvent& event);



//private slots:
public
slots:


	void addImageFiducials();
	void test(QAbstractButton *pushButton);
	void deleteAllImageFiducials();


	void initializeQuadrantView();


	void readCTDataset(ImageSpatialObjectType::Pointer dicomSpatialObject);
	void displayCTDataSet();

	//void changeImageWindowing(int windowing);

	void getCTImageBounds(ImageSpatialObjectType::Pointer);

	void setCursorPosition();


	void refreshImageViews();
	void resetImageCameraSettings();

	void resliceImage(IndexType index);
	void resliceImageViews(int value);


	void imagePickingProcessing();
	void imagePickingProcessingAxial(const itk::EventObject & event);
	void imagePickingProcessingSagittal(const itk::EventObject & event);
	void imagePickingProcessingCoronal(const itk::EventObject & event);

	void requestChangeSelectedFiducial();
	void setImageFiducialProcessing();
	void saveFiducialsInFile();
	void readFiducialsFromFile();

	void addTrackerFiducials();
	void addTrackerFiducialsProcessing();
	void test2(QAbstractButton *pushButtonTracker);
	void deleteAllTrackerFiducials();

	void finishImageAndTrackerFiducialsProcessing();
	//void acceptFiducial(int fiducialID, PointType point);
	void startRegistrationNavigationProcessing();
	void finishRegistrationNavigationProcessing();
	void setTrackerFiducialProcessing();

	void requestToggleTracking();
	void requestToggleNavigate();

	void startTrackingProcessing();
	void stopTrackingProcessing();
	void newFiducialPlan();

	//void requestChangeSelectedTrackerFiducial();
	void pulseTimerEvent();



private:


	static trackerNavigationPlugin									*instance;
	ctkPluginContext												*context;

	Ui::toolFrameTrackerNavigationGUI								m_toolFrameTrackerNavigationGUI;
	Ui::mainFrameTrackerNavigationViewGUI							m_mainFrameNavigationViewGUI;

	trackerNavigationInterface										*trackerNavigationInterfaceInstance;

	QWidget															*toolFrameTrackerNavigationWidget;
	QWidget															*mainFrameVisualizationTrackerNavigationViewWidget;



	QPushButton 													*pushButton;
	QButtonGroup 													*buttongroup;

	QPushButton 													*pushButtonTracker;
	QButtonGroup 													*buttonGroupTracker;


	int																m_maxFiducials;
	int																m_maxFiducialsTracker;

	int 															m_firstRow;
	int																m_secondRow;
	int																m_thirdRow;
	int 															m_fourthRow;
	int 															m_fifthRow;

	int 															m_firstColumn;
	int 															m_secondColumn;
	int 															m_thirdColumn;
	int 															m_fourthColumn;
	int 															m_fifthColumn;
	int 															m_sixthColumn;


	int 															m_firstRowTracker;
	int																m_secondRowTracker;
	int																m_thirdRowTracker;
	int 															m_fourthRowTracker;
	int 															m_fifthRowTracker;

	int 															m_firstColumnTracker;
	int 															m_secondColumnTracker;
	int 															m_thirdColumnTracker;
	int 															m_fourthColumnTracker;
	int 															m_fifthColumnTracker;
	int 															m_sixthColumnTracker;

	QString 														m_MissingText;
	QString 														m_XCoordiante;
	QString 														m_YCoordiante;
	QString 														m_ZCoordiante;


	void createWidgetsAndSignalSlotActions();
	void initImageDataTracker();


	trackerNavigationPlugin(const trackerNavigationPlugin&); // purposely not implemented
	void operator=(const trackerNavigationPlugin&); // purposely not implemented

	static void onVTKUpdateEvent(vtkObject *caller, unsigned long vtkNotUsed(eid), void *, void *av);
	void onITKProgressEvent(itk::Object *source, const itk::EventObject &);

	RegistrationType::LandmarkTrackerPointType							*m_TPoint;

	RegistrationType::LandmarkTrackerPointType							*toolPosition;
	RegistrationType::LandmarkTrackerPointType							*toolRotation;

	RegistrationType::Pointer 											registration;
	igstk::TransformObserver::Pointer									lrtcb;

	IndexType crossHairIndex;
	bool																isRegistered;

	QMutex																mutex;
	long long lastGUIRefreshing;


	/** DICOM image reader */
	ImageReaderType::Pointer                              			m_ImageReader;

	/** DICOM image observers */
	CTImageObserver::Pointer                                		m_ImageObserver;

	LandmarkPointContainerType                            			m_CandidateLandmarks;

	std::string                                           			m_ImageDir;
	std::string                                           			m_PlanFilename;
	std::string                                           			m_PlanFilenamePath;

	igstk::FiducialsPlan                                			*m_Plan;

	View2DType::Pointer												m_ViewImageAxial;
	View2DType::Pointer												m_ViewImageSagittal;
	View2DType::Pointer												m_ViewImageCoronal;
	View3DType::Pointer												m_ViewMPR;

	ReslicerPlaneType::Pointer										m_AxialImagePlaneSpatialObject;
	ReslicerPlaneType::Pointer										m_SagittalImagePlaneSpatialObject;
	ReslicerPlaneType::Pointer										m_CoronalImagePlaneSpatialObject;

	vtkCallbackCommand												*m_vtkUpdateCommand;

	Annotation2DImageType::Pointer 									m_AnnotationImageAxial;
	Annotation2DImageType::Pointer 									m_AnnotationImageSagittal;
	Annotation2DImageType::Pointer 									m_AnnotationImageCoronal;
	Annotation2DImageType::Pointer									m_AnnotationImageMPR;
	Annotation2DImageType::Pointer									m_AnnotationImage3DObject;

	igstk::EventHelperType::ImageExtentType							m_ImageExtent;

	QProcess														*m_TrackerClientProcess;

	QMessageBox 													*m_messageDialog;

	std::string														m_CTImageDirectory;

	std::string														m_AxialAnnotation;
	std::string														m_AxialAnnotationPatientName;
	std::string														m_SagittalAnnotation;
	std::string														m_CoronalAnnotation;
	std::string														m_MPRand3DAnnotation;

	double                                                			m_WindowLevel;
	double                                                			m_WindowWidth;

	int																m_maxFiducialNumber;
	int																m_ActualFiducialNumber;
	int																m_FiducialSize;

	int																m_maxFiducialNumberTracker;
	int																m_ActualFiducialNumberTracker;
	int																m_FiducialSizeTracker;

	double                                              			m_TrackerRMS;
	bool                                                			m_AxialViewInitialized;
	bool                                                			m_SagittalViewInitialized;
	bool                                                			m_CoronalViewInitialized;

	bool                                            				m_ImagePlanesIn3DViewEnabled;
	bool                                            				m_ModifyImageFiducialsEnabled;
	bool															m_ModifyTrackerFiducialsEnabled;

	bool                                               				m_NavigationEnabled;
	bool                                                			m_TrackingEnabled;

	double															m_WindowLevelImage;
	double															m_WindowWidthImage;

	QString															m_BorderGreenStyle;
	QString															m_BorderRedStyle;
	QString															m_BorderGreyStyle;
	QString															m_BackgroundBlueStyle;
	QString															m_BackgroundGreenStyle;
	QString															m_BackgroundWhiteStyle;
	QString															m_BackgroundYellowStyle;
	QString															m_BorderYellowStyle;


	double															m_DefaultZoomImageAxial;
	double															m_DefaultZoomImageCoronal;
	double															m_DefaultZoomImageSagittal;
	double															m_DefaultZoomImageMPR;

	bool															m_ImageLoaded;

	int 															m_MinWindowLevelValue;
	int 															m_MaxWindowLevelValue;

	int 															m_MinWindowWidhtValue;
	int 															m_MaxWindowWidhtValue;


	ofstream						 								m_OutFile;
	std::stringstream												m_PointFileStream;
	ofstream														m_OutFileReg;
	int																m_CoordNr;

	/* Command used for progress tracking */
	itk::SmartPointer<ProgressCommandType>                			m_ProgressCommand;

	/** image spatial object */
	ImageSpatialObjectType::Pointer                       			m_ImageSpatialObject;

	/** tool projection spatial object */
	ToolProjectionType::Pointer                           			m_ToolProjection;

	/** cross hair spatial object */
	CrossHairType::Pointer                               			m_CrossHair;

	/** tool projection representations */
	ToolProjectionRepresentationType::Pointer						m_AxialToolProjectionRepresentation;
	ToolProjectionRepresentationType::Pointer						m_SagittalToolProjectionRepresentation;
	ToolProjectionRepresentationType::Pointer						m_CoronalToolProjectionRepresentation;

	/** cross hair representation */
	CrossHairRepresentationType::Pointer        					m_AxialCrossHairRepresentation;
	CrossHairRepresentationType::Pointer        					m_SagittalCrossHairRepresentation;
	CrossHairRepresentationType::Pointer        					m_CoronalCrossHairRepresentation;
	CrossHairRepresentationType::Pointer        					m_3DViewCrossHairRepresentation;

	/** a vector of mesh spatial objects */
	std::vector< MeshType::Pointer >                      			m_MeshVector;

	/** tool spatial object and representation */
	MeshType::Pointer                                     			m_ToolSpatialObject;
	MeshRepresentationType::Pointer                       			m_ToolRepresentation;

	ReslicerPlaneType::Pointer                     					m_AxialPlaneSpatialObject;
	ReslicerPlaneType::Pointer                     					m_SagittalPlaneSpatialObject;
	ReslicerPlaneType::Pointer                     					m_CoronalPlaneSpatialObject;

	ImageRepresentationType::Pointer               					m_AxialPlaneRepresentation;
	ImageRepresentationType::Pointer               					m_SagittalPlaneRepresentation;
	ImageRepresentationType::Pointer               					m_CoronalPlaneRepresentation;

	ImageRepresentationType::Pointer               					m_AxialPlaneRepresentation2;
	ImageRepresentationType::Pointer               					m_SagittalPlaneRepresentation2;
	ImageRepresentationType::Pointer               					m_CoronalPlaneRepresentation2;

	std::vector< MeshRepresentationType::Pointer >     				m_MeshRepresentationVector;

	std::vector< MeshResliceRepresentationType::Pointer >			m_AxialMeshResliceRepresentationVector;
	std::vector< MeshResliceRepresentationType::Pointer >			m_SagittalMeshResliceRepresentationVector;
	std::vector< MeshResliceRepresentationType::Pointer >			m_CoronalMeshResliceRepresentationVector;

	/** Landmark registration points containers */
	LandmarkPointContainerType                       				m_LandmarksContainer;
	AcceptedLandmarkPointContainerType               				m_AcceptedLandmarksContainer;





	/** typedef for the vector of tracker tools */
	typedef std::vector < igstk::TrackerTool::Pointer >    ToolVectorType;

	igstk::TrackerTool::Pointer                           			m_TrackerTool;
	igstk::TrackerTool::Pointer                           			m_ReferenceTool;


	  /** Observer type for loaded event,
	   *  the callback can be set to a member function. */
	  typedef itk::ReceptorMemberCommand < trackerNavigationPlugin > LoadedObserverType;
	  typedef itk::SimpleMemberCommand < trackerNavigationPlugin > CancelObserverType;

	  LoadedObserverType::Pointer               m_AxialViewPickerObserver;
	  LoadedObserverType::Pointer               m_SagittalViewPickerObserver;
	  LoadedObserverType::Pointer               m_CoronalViewPickerObserver;

	  LoadedObserverType::Pointer               m_ManualReslicingObserver;
	  LoadedObserverType::Pointer               m_KeyPressedObserver;
	  LoadedObserverType::Pointer               m_MousePressedObserver;
	  LoadedObserverType::Pointer               m_TrackerToolUpdateObserver;
	  LoadedObserverType::Pointer               m_TrackerToolNotAvailableObserver;
	  LoadedObserverType::Pointer               m_TrackerToolAvailableObserver;
	  LoadedObserverType::Pointer               m_ReferenceNotAvailableObserver;
	  LoadedObserverType::Pointer               m_ReferenceAvailableObserver;

	  /** Ellipsoid spatial object, used to represent the fiducial points*/
	  typedef igstk::EllipsoidObject                  EllipsoidType;
	  typedef igstk::EllipsoidObjectRepresentation    EllipsoidRepresentationType;

	  EllipsoidType::Pointer                          m_PickedPoint;
	  EllipsoidRepresentationType::Pointer            m_PickedPointRepresentation;


	  EllipsoidType::Pointer                          m_TrackerPoint;
	  EllipsoidRepresentationType::Pointer            m_TrackerPointPointRepresentation;

	  /** Objects for path planning and image fiducial selection */
	  std::vector< EllipsoidType::Pointer >                m_FiducialPointVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_AxialFiducialRepresentationVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_SagittalFiducialRepresentationVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_CoronalFiducialRepresentationVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_3DViewFiducialRepresentationVector;


	  std::vector< EllipsoidType::Pointer >                m_TrackerFiducialPointVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_AxialTrackerFiducialRepresentationVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_SagittalTrackerFiducialRepresentationVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_CoronalTrackerFiducialRepresentationVector;
	  std::vector< EllipsoidRepresentationType::Pointer >  m_3DViewTrackerFiducialRepresentationVector;



	  igstk::Transform                                m_RegistrationTransform;
	  igstk::Transform                                m_PickingTransform;
	  igstk::Transform                                m_TrackerToolTransform;
	  igstk::Transform::VersorType					m_CurrentTrackerToolOrientation;

	  igstk::FiducialsPlanIO 											*fiducialWriter;
	  igstk::FiducialsPlanIO 											*fiducialReader;

	  /** Define a initial world coordinate system */
	  typedef igstk::AxesObject                       AxesObjectType;
	  AxesObjectType::Pointer                         m_WorldReference;


	  /** Log file */
	  std::ofstream                                   m_LogFile;

	  /** Utility functions, conversion between points and transform */
	  inline
	  igstk::Transform
	  PointToTransform( PointType point)
	  {
	    igstk::Transform transform;
	    igstk::Transform::VectorType translation;
	    for (unsigned int i=0; i<3; i++)
	      {
	      translation[i] = point[i];
	      }
	    transform.SetTranslation( translation, 0.1, igstk::TimeStamp::GetLongestPossibleTime() );
	    return transform;
	  }

	  inline
	  ImageSpatialObjectType::PointType
	  TransformToPoint( igstk::Transform transform)
	  {
	    ImageSpatialObjectType::PointType point;
	    for (unsigned int i=0; i<3; i++)
	      {
	      point[i] = transform.GetTranslation()[i];
	      }
	    return point;
	  }



}; // trackerNavigationPlugin

#endif // trackerNavigationPlugin_H
